/* The Knight's Tour                                                         */
/* Copyright C. Broadribb 1995                                               */
/* 28/4/95                                                                   */

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <dos.h>

/* The following macro returns a random number between min and max.  If max is < 0 then it returns 0. */
#define rnd( min, max ) (max > 0)?((rand() % (int)(((max)+1) - (min))) + (min)):0

/* These define the desired colours. */
#define light LIGHTGRAY
#define dark BROWN
#define knightcolour BLACK
#define markercolour BLACK
#define normalb BLACK
#define normalf WHITE


/* This macro returns true if position y, x is a light coloured square.  */
#define lightsquare (y % 2 == 0 && x % 2 == 0) || (y % 2 == 1 && x % 2 == 1)

enum boolean { false, true };

void initialiseboard (char [9][9], int [9][9]);
void drawboard ();
void showmoves (int [9][9]);
void drawknight (char [9][9], int, int, int);
void marksquare (char [9][9], int, int);
void inputstart (int *, int *);
void choosestart (int *, int *);
void choosemove (int [9][9], int *, int *);
enum boolean keypress ();
enum boolean askuser();

/* This initialises path with the direction indicators to generate a path around the chess board. */
// This is global because otherwise of memory problems
int path [9][9] =
{
	0,0,0,0,0,0,0,0,0,
	0,1,2,8,2,1,8,1,2,
	0,7,2,4,4,7,7,4,2,
	0,7,2,8,1,5,4,5,2,
	0,1,5,5,3,6,2,1,5,
	0,1,8,6,6,4,4,2,4,
	0,6,2,3,1,4,8,6,2,
	0,8,8,6,3,6,8,6,3,
	0,7,5,7,5,7,4,5,5
};


void main (int argc, char *argv[])
{
	char board [9][9];
	int history [9][9];
	int xpos, ypos, oldx, oldy, moveno;
	enum boolean autoplay, playgame, runprog, checkkey;


	/* Seed the random number generator. */
	srand( (unsigned)time( NULL ) );

	runprog = true;
	autoplay = false;
	if (argc > 1 && stricmp (argv[1], "/a") == 0)
		autoplay = true;
	do
	{
		moveno = 0;
		playgame = true;
		initialiseboard (board, history);
		drawboard ();

		if (autoplay == true)
			choosestart (&xpos, &ypos);
		else
		{
			inputstart (&xpos, &ypos);
			drawboard ();
		}

		do
		{
			moveno ++;
			drawknight (board, xpos, ypos, moveno);
			history [ypos][xpos] = moveno;
			if (moveno == 64)
			{
				playgame = false;
				if (autoplay == false)
				{
					showmoves (history);
					runprog = askuser ();
				}
			}
			else
			{
				oldx = xpos;
				oldy = ypos;
				choosemove (path, &xpos, &ypos);
				marksquare (board, oldx, oldy);
			}

			if (autoplay == true)
			{
				checkkey = keypress();
				if (checkkey == true)
					runprog = false;
			}
		} while (runprog == true && playgame == true);

	} while (runprog == true);
}


void initialiseboard (char board [9][9], int history [9][9])
{
	/* Post: board is initialised to blank spaces.  History is           */
	/* initialised to zeros.                                             */

	int y, x;

	for (y = 1; y <= 8; y ++)
		for (x = 1; x <= 8; x ++)
		{
			board [y][x] = ' ';
			history [y][x] = 0;
		}
}


void drawboard ()
{
	/* Post:  the chess board is drawn on the screen.                    */

	char temp [5];
	int x, y;

	clrscr();
	textbackground (normalb);
	textcolor (normalf);
	cputs ("   1  2  3  4  5  6  7  8\r\n");
	cputs (" Ŀ\r\n");
	for (y = 1; y <= 8; y ++)
	{
		textcolor (normalf);
		sprintf (temp, "%i",y);
		cputs (temp);
		for (x = 1; x <= 8; x ++)
		{
			if (lightsquare)
				textcolor (light);
			else
				textcolor (dark);
			cputs ("");
		}
		textcolor (normalf);
		sprintf (temp, "%i\r\n",y);
		cputs (temp);
	}
	cputs (" \r\n");
	cputs ("   1  2  3  4  5  6  7  8\r\n");
}



void showmoves (int history [9][9])
{
	/* Pre:  history has the move number for each chess square.          */
	/* Post: The move number for each square is displayed on the screen. */

	int y, x;
	char move [3];

	for (y = 1; y <= 8; y ++)
		for (x = 1; x <= 8; x ++)
		{
			gotoxy(x*3+1,y+2);
			textcolor (knightcolour);
			if (lightsquare)
				textbackground (light);
			else
				textbackground (dark);
			sprintf (move, "%0.2i",history [y][x]);
			cputs (move);
	       }
	textbackground (normalb);
	textcolor (normalf);
}


void drawknight (char board [9][9], int x, int y, int moveno)
{
	/* Pre:  x and y are valid coordinates on the chess board.           */
	/* Post: The knight is drawn on the screen at position y,x and the   */
	/* row, column and move number are displayed at the bottom of the    */
	/* chess board.                                                      */

	char info [80];
	long unsigned a;
	board [y] [x] = 'K';
	gotoxy (x*3+1,y+2);
	textcolor (knightcolour);
	if (lightsquare)
		textbackground (light);
	else
		textbackground (dark);
	cputs ("K");
	gotoxy (1,20);
	textbackground (normalb);
	textcolor (normalf);
	sprintf (info,"Row:  %i, column:  %i, move number:  %i",y, x, moveno);
	cputs (info);
	delay (1000);
}


void marksquare (char board [9][9], int x, int y)
{
	/* Pre:  x and y are valid coordinates on the chess board.           */
	/* Post: A marker is displayed at position y,x.                      */

	board [y] [x] = '*';
	gotoxy(x*3+1,y+2);
	textcolor (markercolour);

	if (lightsquare)
		textbackground (light);
	else
		textbackground (dark);
	cputs ("*");
	textbackground (normalb);
	textcolor (normalf);
}


void inputstart (int *xpos, int *ypos)
{
	/* Post: xpos and ypos contain x and y coordinates input by the      */
	/* user.                                                             */
	/* If the user enters invalid input for the x or y coordinates then  */
	/* an error message is displayed and the user must enter them again. */

	int x, y;
	char input [10];

	gotoxy (1,20);
	do
	{
		cputs ("Enter starting position (row, column):  ");

		/* Empty the keyboard buffer. */
		fflush (stdin);

		gets (input);
		cputs ("\r\n");
		sscanf (input, "%i,%i", &y, &x);
		if (y < 1 || y > 8)
			cputs ("Row must be from 1 to 8.\r\n");
		if (x < 1 || x > 8)
			cputs ("Column must be from 1 to 8.\r\n");
	} while (x < 1 || x > 8 || y < 1 || y > 8);
	*xpos = x;
	*ypos = y;
}


void choosestart (int *xpos, int *ypos)
{
	/* Post: xpos and ypos have randomly generated values between 1 and  */
	/* 8.                                                                */

	*xpos = (rnd (1,8));
	*ypos = (rnd (1,8));
}


void choosemove (int path [9][9], int *xpos, int *ypos)
{
	/* Pre:  Path contains valid direction indicators (numbers between   */
	/* 1 and 8).  Xpos and ypos are valid coordinates on the chess board.*/
	/* Post:  xpos and ypos hold the new coordinates.                    */

	int direction;
	direction = path [*ypos][*xpos];
	switch (direction)
	{
		case 1: *xpos += 1; *ypos += 2; break;
		case 2: *xpos -= 1; *ypos += 2; break;
		case 3: *xpos -= 2; *ypos += 1; break;
		case 4: *xpos -= 2; *ypos -= 1; break;
		case 5: *xpos -= 1; *ypos -= 2; break;
		case 6: *xpos += 1; *ypos -= 2; break;
		case 7: *xpos += 2; *ypos -= 1; break;
		case 8: *xpos += 2; *ypos += 1; break;
	};

}


enum boolean keypress ()
{
	/* Post: if a key has been pressed then keypress returns true.       */
	/* Otherwise, keypress returns false.                                */

	int key;

	key = kbhit();
	if (key)                /* kbhit returns 0 if no key is pressed or a number if a key is pressed. */
	{
		getch();        /* Read the key press and discard it */
		return (true);
	}
	else
		return (false);
}


enum boolean askuser()
{
	/* Post: if the user wishes to run another tour, askuser returns     */
	/* true.  Otherwise, askuser returns false.                          */

	char answer;
	int a;

	do
	{
		gotoxy (21,1);

		/* Empty the keyboard buffer */
		fflush (stdin);
		gotoxy (1,22);
		cputs ("Do you want another tour (y/n)?  ");
		scanf ("%c", &answer);

	} while (answer != 'n' && answer != 'N' && answer != 'y' && answer != 'Y');

	if (answer == 'y' || answer == 'Y')
	       return (true);
	else
	       return (false);

}
